#! /bin/bash

# The easiest way to create a shear stress file is to partition the area of interest into places where you want to be able to vary the shear stress.

# The way I have done this is to create a shapefile that partitions the area as desired. I then exported the shapefile into a CSV file.
# from QGIS:
# > Open shapefile
# > Layer dropdown menu > save as
# > in the options, change "Symbology Export" to "feature symbology", and "Geometry" as "AS_WKT".
# > Change the CRS to WGS 84, or else it will not export the points as latitude/longitude



lat_spacing=0.05
long_spacing=0.05

csv_file=polygons.csv


gawk 'BEGIN { FPAT = "([^,]+)|(\"[^\"]+\")"} {if(NR > 1) {print ">", $3; print $1} }' ${csv_file} | sed -e 's/\"POLYGON ((//g'  | sed -e 's/))\"//g' | sed -e 's/,/\n/g' | sed -e 's/(//g' | sed -e 's/)//g' > gmt_file.txt

./create_ss_grid ${lat_spacing} ${long_spacing}


#gawk 'BEGIN { FPAT = "([^,]+)|(\"[^\"]+\")"} {if(NR > 1) {print $3, $4} }' ${csv_file}  > shear_stress_domain_values.txt
