#! /bin/bash

# In my setup, I have stored the icesheet binary in a local bin directory, change as needed

PATH=${PATH}:/home/evan/bin
export PATH

# base folder where everything is stored. Change this!
current_folder=/home/evan/experiments/naice_setup 



shear_stress_model=20009 # csv file with the shear stress values through time
margin_model=20 # margin reconstruction values


# first calculate without GIA
iteration=0

old_icemodel="null" # first step doesn't have a previous ice model




# icesheet parameters, in metres

initiation_distance=5000
elevation_contour_interval=20

# GIA Earth model, used for calculating deformation for the whole domain

earth_model="null" # first run uses modern topography

title="${iteration}_${earth_model}_${shear_stress_model}_${margin_model}"
ice_file="naice_${title}" # the final model file, it will be in a format that calsea (see Lambeck et al. 2003 doi:10.1016/S0277-3791(02)00142-7)

# this should contain all the times (in thousands of years) in the margin model directory

cat << END > times_to_calculate
160
140
130
120
110
90
80
70
60
50
40
30
28
26
24
22
20
18
17
16
15
14
13.5
13
12.5
12
11.5
11
10.5
10
9.5
9
8.5
8
7.5
7
6.5
6
5
0
END

cat << END > times_to_calculate
5
0
END
echo icefile:
echo ${current_folder}/imodels/${ice_file}


if [ ! -e ${current_folder}/imodels/${ice_file} ] # no point calculating if it has already been done
then
	mkdir ${current_folder}/run/${shear_stress_model}_${margin_model}_${iteration}

	for time_var in $( cat times_to_calculate)
	do


		time_folder=$( echo ${time_var} 1000  | awk '{print $1 * $2}' ) 

#time_folder=$1
#margin_model=$2
#shear_stress_model=$3
#old_icemodel=$4
#iteration=$5
#earth_model=$6
#initiation_distance=$7
#elevation_contour_interval=$8


		bash terra_init4.sh ${time_folder} ${margin_model} ${shear_stress_model} ${old_icemodel} ${iteration} ${earth_model} ${initiation_distance} ${elevation_contour_interval}


	done

	wait
	echo "running merge3.sh"

	bash  merge3.sh ${shear_stress_model} ${margin_model} ${iteration} ${earth_model}

	wait
fi



# make sure the file is there

if [ -e ${current_folder}/imodels/${ice_file} ]
then

	echo "finished initial model"
	date 

else

	echo "did not calculate initial ice model for some reason"
	date
	exit 0
fi





# GIA Earth model, used for calculating deformation for the whole domain

earth_model="ehgk" # 120 km lithosphere, 4x10^20 Pa s upper mantle, 10^22 Pa s lower mantle

for iteration in 1 2
do


old_icemodel=${ice_file}

title="${iteration}_${earth_model}_${shear_stress_model}_${margin_model}"
ice_file="naice_${title}"

if [ ! -e ${current_folder}/imodels/${ice_file} ] # no point calculating if it has already been done
then




	# first calculate the deformation, everything is in the folder ~/def_mod

	if [ ! -e ${current_folder}/def_mod/${ice_file}.def ]
	then

		# note that I cannot include calsea since I do not have permission. I have included the calculated
		# GIA in this archive so you can still run this. If you want to calculate GIA, you must
		# use your own program. One suggestion is to use SELEN, written by Spada et al (http://www.fis.uniurb.it/spada/SELEN_minipage.html)
		# One drawback of this versus the ANU calsea program is that it does not include horizontally migrating shorelines,
		# so in places where the shorline has significanly changed since deglaciation, such as around Hudson Bay, it will
		# probably not give the exact correct GIA signature.
		#
		 #run_calsea.sh ${earth_model} ${shear_stress_model} ${margin_model} ${inode} ${job_number} ${iteration} &

		wait

	fi



	if [ ! -e ${current_folder}/def_mod/${ice_file}.def ]
	then

		echo "calsea failed for iteration ${iteration}" 
		exit 0
	fi
	

	mkdir ${current_folder}/run/${shear_stress_model}_${margin_model}_${iteration}



	for time_var in $( cat times_to_calculate)
	do


		time_folder=$( echo ${time_var} 1000  | awk '{print $1 * $2}' ) 

#time_folder=$1
#margin_model=$2
#shear_stress_model=$3
#old_icemodel=$4
#iteration=$5
#earth_model=$6
#initiation_distance=$7
#elevation_contour_interval=$8


		bash terra_init4.sh ${time_folder} ${margin_model} ${shear_stress_model} ${old_icemodel} ${iteration} ${earth_model} ${initiation_distance} ${elevation_contour_interval}
		

	done

	wait
	echo "running merge3.sh" 
	date
	bash  merge3.sh ${shear_stress_model} ${margin_model} ${iteration} ${earth_model}
fi



if [ -e ${current_folder}/imodels/${ice_file} ]
then

	echo "finished iteration ${iteration} of ice model" 
	date
else

	echo "did not calculate iteration ${iteration}  of ice model for some reason" 
	date 
	exit 0

fi

done

# clean up files

rm -R 20009_20_*
rm -R ${current_folder}/temp
rm times_to_calculate
