#! /bin/bash

PATH=${PATH}:/home/evan/bin
export PATH



time_folder=$1
initiation_distance=$2
elevation_contour_interval=$3
earthmodel=$4
old_icemodel=$5


rm timing-${initiation_distance}-${elevation_contour_interval}.txt


deform_model="${earthmodel}.${old_icemodel}"
if [ "${earthmodel}" = "null" ]
then
deform_model=""
fi

if [ "$time_folder" = "0" ]
then
	deform_model=""
fi

longtext="Longitude"
longmin=-180
longmax=0
longtickint=20
longsubtickint=10

lattext="Latitude"
latmin=30
latmax=85
lattickint=10
latsubtickint=5


rm ice_models/$time_folder/model_values.txt
rm ice_models/$time_folder/*contours
rm ice_models/$time_folder/*rejected
rm ice_models/$time_folder/timing*


elevation_parameter_file="elev_parameters.txt"
shear_stress_parameter_file="ss_parameters.txt"
ice_margin=outline.xyz
for ice_files in $(ls ice_models/$time_folder)
do
	noextension=$(echo $ice_files | sed -e 's/.txt//')

rm ${ice_margin}  ${elevation_parameter_file} ${shear_stress_parameter_file}



bash convert_grid.sh ice_models/$time_folder/${ice_files} 

if [ ! -e ${ice_margin} ]
then
	pwd
	echo "did not create ${ice_margin}"
	exit 0
fi

if [ ! -e ${elevation_parameter_file} ]
then
	pwd
	echo "did not create ${elevation_parameter_file}"
	exit 0
fi

if [ ! -e ${shear_stress_parameter_file} ]
then
	pwd
	echo "did not create ${shear_stress_parameter_file}"
	exit 0
fi


cat << END_params > params.txt
${ice_margin}
${elevation_parameter_file}
${shear_stress_parameter_file}
${elevation_contour_interval}
${initiation_distance}
END_params

echo "contents of the elevation parameter file:"
cat ${elevation_parameter_file}
echo

echo "contents of the shear stress parameter file:"
cat ${shear_stress_parameter_file}
echo


		echo the following is in params.txt:
		cat params.txt
		echo
#		echo now listing the files here
#		ls -l -t

		cat params.txt >> timing-${initiation_distance}-${elevation_contour_interval}.txt
		echo "start time" >> timing-${initiation_distance}-${elevation_contour_interval}.txt
		 date >> timing-${initiation_distance}-${elevation_contour_interval}.txt

		echo "*****************************************************************"
		echo ice_models/${time_folder}/${ice_files}
		echo starting icesheet
		date
		echo



		icesheet
		echo "end time" >> timing-${initiation_distance}-${elevation_contour_interval}.txt
		date >> timing-${initiation_distance}-${elevation_contour_interval}.txt



if [ ! -e contours.txt ]
then
	pwd
	echo "icesheet failed to run"
	exit 0
fi

		cp contours.txt ice_models/$time_folder/$noextension.contours
		cp contours-rejected.txt ice_models/$time_folder/$noextension.contours-rejected

		gawk '{ if ($1 == ">" ){ } else {print $1, $2, $4}}' ice_models/$time_folder/$noextension.contours > awk.out



		center_longitude=-108
		center_latitude=61

		southern_standard_parallel=47
		northern_standard_parallel=74

map_width=20c # likely arbitrary

		lat_long_file=ll_file.txt

		mapproject awk.out  -R${longmin}/${longmax}/${latmin}/${latmax} -F -C -I -Jb${center_longitude}/${center_latitude}/${southern_standard_parallel}/${northern_standard_parallel}/${map_width}  > ${lat_long_file}


		blockmean -R${longmin}/${longmax}/${latmin}/${latmax} -I.5/.25 ${lat_long_file} > bm.out

		surface bm.out -Gthickness_surface.grd  -I.5/.25 -Rg$longmin/$longmax/$latmin/$latmax -T0.35  
		grdmask -I.5/.25 -R${longmin}/${longmax}/${latmin}/${latmax} ice_models/$time_folder/${ice_files} -Gmask.grd -N0/0/1

		grdmath thickness_surface.grd  mask.grd MUL = masked_thickness.grd

		grd2xyz masked_thickness.grd > elev_surface.txt

		awk '{if ($3 > 2) print $1, $2, $3}' elev_surface.txt > elev_surface2.txt

#		awk  '{ if ($3 > 0) { print $1, $2, $3}}' elev_surface_zeroed.txt >> ice_models/$time_folder/model_values.txt
		cat elev_surface2.txt >> ice_models/$time_folder/model_values.txt

	done

mv timing-${initiation_distance}-${elevation_contour_interval}.txt ice_models/$time_folder/timing-${initiation_distance}-${elevation_contour_interval}.txt




