#! /bin/bash

PATH=${PATH}:/home/evan/bin
export PATH

# base folder where everything is stored. Change this!
current_folder=/home/evan/experiments/naice_setup 


age=$1 #20000

shear_stress_model=$2 # 20000

awk '{if (NR == 1) print $0}' ${shear_stress_model}.csv > timelist.txt
sed 's/,/\n/g' timelist.txt > timelist_column.txt

column_number=$(awk --assign age=${age} '{if($1 == age/1000) print NR  }' timelist_column.txt)

rm timelist_column.txt timelist.txt

echo "Age and column: " $age ${column_number}

gawk --assign column=${column_number} --field-separator=',' '{if (NR > 1) print $1, $column * 1000}' ${shear_stress_model}.csv > shear_stress_domains.txt

if [ ! -f domains.txt ]
then
  cp ${current_folder}/shear_stress_domains/domains.txt .
fi

convert_grid shear_stress_domains.txt
