	SUBROUTINE read_ice(filename, times, numcolat, numtimes, latsp, longsp, colat, colong, ivalues, longvalue)

! This subroutine reads a CALSEA type ice model file

	IMPLICIT NONE

	CHARACTER(len=255)	:: filename, infoline
	REAL 			:: latsp, longsp, colat(720), colong(720,720), ivalues(720, 720, 140), times(140), ncolat, scolat
	INTEGER		:: numtimes, numcolat, longvalue(720), k, l, st, numlong
 


	OPEN (unit=10, file=filename, form="formatted",	access="sequential", status="old")

	rewind(unit=10)

	READ(10,*) infoline
!	WRITE(6,*) infoline

	read(10,*) ncolat, scolat
	read(10,*) longsp, latsp
	read(10,*) numtimes
	
	read(10,*) (times(k), k = 1, numtimes, 1)

	numcolat = 1
	
	do

		READ(10, *, iostat=st) colat(numcolat), numlong

		if (st < 0) EXIT

		longvalue(numcolat) = numlong

		do l = 1, numlong, 1

!			write(6,*) numcolat, l

			read(10,*) colong(numcolat,l), (ivalues(numcolat, l, k), k = 1, numtimes, 1)


!			write(6,*) numcolat, l, k
!			write(6,*) colat(numcolat), colong(numcolat,l), ivalues(numcolat,l,6)


		enddo

		numcolat = numcolat + 1
	ENDDO


	close (unit=10)

	
	END SUBROUTINE read_ice
