	SUBROUTINE read_def(filename, times, numcolat, numlong, numtimes, latsp, longsp, north, west, ivalues, max_times,&
		max_number_coords)

! This subroutine reads a calhornew deformation file

	IMPLICIT NONE

	integer, intent(in) :: max_times, max_number_coords

	CHARACTER(len=255)	:: filename, infoline, format1, format2
	REAL 			:: latsp, longsp
	real			:: ivalues(max_number_coords, max_number_coords, max_times), times(max_times), north, south, west, east
	real			:: latitude, longitude, response(max_times)
	INTEGER		:: numtimes, numcolat, k, l, st, numlong, lat_index, long_index, format_size



	OPEN (unit=10, file=filename, form="formatted",	access="sequential", status="old")

	rewind(unit=10)

!	READ(10,*) infoline
!	WRITE(6,*) infoline

	read(10,*) numtimes, north, west, south, east, latsp, longsp, numcolat, numlong
!	write(6,*) numtimes, north, west, south, east, latsp, longsp, numcolat, numlong
	if(west < 0) THEN
		west = 360. + west
	endif

	if (east <= 0.) THEN
		east = 360. + east
	endif

	north = 90.-north
	south = 90.-south

	ivalues = 0
!	write(6,*) max_times, numtimes

	format_size = int(log10(real(numtimes)))+1
	write(6,*) format_size
	write(format2,"(A5,I1,A4)") '(A2,I', format_size, ',A5)'

	format2 = adjustl(format2)
!	write(6,*) format2

	write(format1,format2) "(", 10, "F6.2)"
!	WRITE(6,*) format1
	read(10,format1) (times(k), k = 1, numtimes, 1)

!	write(6,*) north, west, times(1:numtimes)
	
	do

		READ(10, *, iostat=st) longitude, latitude, (response(k), k = 1, numtimes, 1)

		if (st < 0) EXIT

		lat_index = nint(((90.-latitude) - north) / latsp) + 1 ! plus one in case the value is zero

		if (longitude <= 0.) THEn
			longitude = 360.+ longitude
		endif

		long_index = nint((longitude - west) / longsp) + 1
!		write(6,*) latitude, longitude, response(1:numtimes)
!		write(6,*) lat_index, long_index
		ivalues(lat_index, long_index, :) = response
		

	ENDDO


	close (unit=10)

	
	END SUBROUTINE read_def
